/* -*- Mode:C; Tab-width:4 -*-*/
/* Mode: C; Tab-Width: 4. */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    */
/*  All rights reserved.                                                 */
/*                                                                       */
#define maxdisks 14		/* these are the same as in nupi.p */
#define ignorevolumesize 0x600000
extern StringPtr	lispm_volume_array[maxdisks];
#define volsize 28		/* volume name limit */


/*----------------------------SIZE  MultiFinder Size Information-----------------------*/

/* Used in lispm.c when recalculating the correct size information. */
struct size
{

#ifdef TRASH
	Boolean saveScreen;         /* Switcher compatibility. */
	Boolean	acceptSuspendResumeEvents;
	Boolean	enableOptionSwitch;
	Boolean	canBackground;
	Boolean	multiFinderAware;
#endif
	unsigned short reserved;  /*	unsigned bitstring[11] = 0;    reserved 			*/
		
	/* Memory sizes are in bytes */
	unsigned long preferredMemorySize;										/* preferred mem size	*/
	unsigned long minimumMemorySize;										/* minimum mem size		*/
};

typedef struct startup_tbl
{ 
	char 		mcrname[32];	
	char 		mcrvolume[32];	
	char 		loadname[32];
	char		loadvolume[32];
	char		hostname[32];
	char		defaultdevice[32];
	int			forslot;
	int         windowBitArraySize;  /* The size in bytes that is required for window bit arrays. */
	int         miscHeapSize;        /* The size in bytes of all other allocatable memory needed. */ 
} startup_tbl;
	
extern startup_tbl			**startup_parms;
extern struct size **sizeinfo;  /* The multiFinder size resource. */

pascal void
write_startup()
	extern;

pascal startup_tbl	**
read_startup()
	extern;

pascal char *
startup_defaultdevice(table)
	startup_tbl	**table;
	extern;

pascal char *
startup_hostname(table)
	startup_tbl	**table;
	extern;
	
pascal char *
startup_loadvolume(table)
	startup_tbl	**table;
	extern;
	
pascal char *
startup_loadname(table)
	startup_tbl	**table;
	extern;
	
pascal char *
startup_mcrname(table)
	startup_tbl	**table;
	extern;
	
pascal char *
startup_mcrvolume(table)
	startup_tbl	**table;
extern;

pascal int
startup_windowBitArraySize(table)
	startup_tbl  **table;
	extern;
	
pascal unsigned char
startup_forslot(table)
	startup_tbl **table;
	extern;


#ifdef TRASH

#define startup_defaultdevice(tbl) 	\
	(&((*tbl)->defaultdevice[0]))

#define startup_hostname(table) 	\
	(&((*table)->hostname[0]))

#define startup_mcrname(table) 	\
	(&((*table)->mcrname[0]))

#define startup_loadname(table) 	\
	(&((*table)->loadname[0]))

#define startup_loadvolume(table) 	\
	(&((*table)->loadvolume[0]))

#define startup_mcrvolume(table) 	\
	(&((*table)->mcrvolume[0]))

#define startup_forslot(table) 	\
	((*table)->forslot)

#define startup_defaultdevice(table) 	\
	(&((*table)->defaultdevice[0]))

#define startup_hostname(table) 	\
	(&((*table)->hostname[0]))

#define windowBitArraySize(table)         \
        ((*table)->windowBitArraySize)


pascal startup_tbl *read_startup() extern; /* make this callable from nupi.p *mbc*/
	
pascal char *STARTUP_DEFAULTDEVICE(table)
     startup_tbl *table;
     extern;

pascal char *STARTUP_HOSTNAME(table)
     startup_tbl	*table;
     extern;

pascal char *STARTUP_LOADVOLUME(table)
     startup_tbl	*table;
     extern;

pascal char *STARTUP_LOADNAME(table)
     startup_tbl	*table;
     extern;

pascal char *STARTUP_MCRNAME(table)
     startup_tbl	*table;
     extern;

pascal char *STARTUP_MCRVOLUME(table)
     startup_tbl	*table;
     extern;
	
/*
pascal int *STARTUP_FORSLOT(table)
     startup_tbl	*table;
     extern;
*/
#endif
